/******************************************************************************
 *
 * Copyright (c) 2003-2004 PalmSource, Inc. All rights reserved.
 *
 * File: limits.h
 *
 * Release: Palm OS Developer Suite 5 SDK (68K) 4.0
 *
 * Description:
 *
 *
 *****************************************************************************/


#ifndef __PALMSOURCE_CC_HDR_LIMITS_H
#define __PALMSOURCE_CC_HDR_LIMITS_H


#define CHAR_BIT	 8

#define SCHAR_MIN	(-127 - 1)
#define SCHAR_MAX	 127

#define UCHAR_MAX	 255

#if __SIGNED_CHARS__
# define CHAR_MIN	 SCHAR_MIN
# define CHAR_MAX	 SCHAR_MAX
#else
# define CHAR_MIN	 0
# define CHAR_MAX	 UCHAR_MAX
#endif

#define MB_LEN_MAX	 1

#define SHRT_MIN	(-32767 - 1)
#define SHRT_MAX	 32767

#define USHRT_MAX	 65535U

#define INT_MIN		(-2147483647 - 1)
#define INT_MAX		 2147483647

#define UINT_MAX	 4294967295U

#define LONG_MIN	(-2147483647L - 1)
#define LONG_MAX	 2147483647L

#define ULONG_MAX	 4294967295UL

/* Note: the following definitions are not part of the C90 or C++ standards */

#define LLONG_MIN	(-9223372036854775807LL - 1)
#define LLONG_MAX	 9223372036854775807LL

#define ULLONG_MAX	 18446744073709551615ULL

#endif /* __PALMSOURCE_CC_HDR_LIMITS_H */
